/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.ibm.icu.text.BreakIterator;
import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.text.CharArrayIterator;
import icyllis.modernui.text.MeasuredText;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineBreaker {
    private static final int NOWHERE = -1;
    private static BreakIterator sBreaker = BreakIterator.getLineInstance((Locale)Locale.ROOT);
    @Nonnull
    private final char[] mTextBuf;
    @Nonnull
    private final MeasuredText mMeasuredText;
    @Nonnull
    private final LineWidth mLineWidthLimits;
    @Nonnull
    private final TabStops mTabStops;
    private int mLineNum = 0;
    private float mLineWidth = 0.0f;
    private float mCharsAdvance = 0.0f;
    private float mLineWidthLimit;
    private int mPrevBoundaryOffset = -1;
    private float mLineWidthAtPrevBoundary = 0.0f;
    private float mCharsAdvanceAtPrevBoundary = 0.0f;
    private final List<BreakPoint> mBreakPoints = new ArrayList<BreakPoint>();

    @Nonnull
    public static Result computeLineBreaks(@Nonnull MeasuredText measuredPara, @Nonnull ParagraphConstraints constraints, @Nullable int[] indents, int lineNumber) {
        float[] floatIndents;
        if (measuredPara.getTextBuf().length == 0) {
            return new Result();
        }
        if (indents == null) {
            floatIndents = null;
        } else {
            floatIndents = new float[indents.length];
            for (int i = 0; i < indents.length; ++i) {
                floatIndents[i] = indents[i];
            }
        }
        DefaultLineWidth lineWidth = new DefaultLineWidth(constraints.mFirstWidth, constraints.mWidth, floatIndents, lineNumber);
        TabStops tabStops = new TabStops(constraints.mVariableTabStops, constraints.mDefaultTabStop);
        return new LineBreaker(measuredPara.getTextBuf(), measuredPara, lineWidth, tabStops).getResult();
    }

    public static boolean isLineEndSpace(char c) {
        return c == '\n' || c == ' ' || c == '\u1680' || '\u2000' <= c && c <= '\u200a' && c != '\u2007' || c == '\u205f' || c == '\u3000';
    }

    static void setLocale(Locale locale) {
        sBreaker = BreakIterator.getLineInstance((Locale)locale);
    }

    public LineBreaker(@Nonnull char[] textBuf, @Nonnull MeasuredText measuredText, @Nonnull LineWidth lineWidthLimits, @Nonnull TabStops tabStops) {
        this.mTextBuf = textBuf;
        this.mMeasuredText = measuredText;
        this.mLineWidthLimits = lineWidthLimits;
        this.mTabStops = tabStops;
        this.mLineWidthLimit = lineWidthLimits.getAt(0);
        this.process();
    }

    private void process() {
        BreakIterator breaker = sBreaker;
        breaker.setText((CharacterIterator)new CharArrayIterator(this.mTextBuf));
        Locale locale = null;
        int nextBoundary = 0;
        for (MeasuredText.Run run : this.mMeasuredText.mRuns) {
            Locale newLocale = run.getLocale();
            if (locale != newLocale) {
                breaker = BreakIterator.getLineInstance(locale);
                nextBoundary = breaker.following(run.mStart);
                locale = newLocale;
            }
            for (int i = run.mStart; i < run.mEnd; ++i) {
                this.updateLineWidth(this.mTextBuf[i], this.mMeasuredText.mAdvances[i]);
                if (i + 1 != nextBoundary) continue;
                if (run.canBreak() || nextBoundary == run.mEnd) {
                    this.processLineBreak(i + 1);
                }
                if ((nextBoundary = breaker.next()) != -1) continue;
                nextBoundary = this.mTextBuf.length;
            }
        }
    }

    private void processLineBreak(int offset) {
        while (this.mLineWidth > this.mLineWidthLimit) {
            int start = this.getPrevLineBreakOffset();
            if (this.tryLineBreak() || !this.doLineBreakWithGraphemeBounds(start, offset)) continue;
            return;
        }
        if (this.mPrevBoundaryOffset == -1) {
            this.mPrevBoundaryOffset = offset;
            this.mLineWidthAtPrevBoundary = this.mLineWidth;
            this.mCharsAdvanceAtPrevBoundary = this.mCharsAdvance;
        }
    }

    private boolean tryLineBreak() {
        if (this.mPrevBoundaryOffset == -1) {
            return false;
        }
        this.breakLineAt(this.mPrevBoundaryOffset, this.mLineWidthAtPrevBoundary, this.mLineWidth - this.mCharsAdvanceAtPrevBoundary, this.mCharsAdvance - this.mCharsAdvanceAtPrevBoundary);
        return true;
    }

    private boolean doLineBreakWithGraphemeBounds(int start, int end) {
        float width = this.mMeasuredText.mAdvances[start];
        for (int i = start + 1; i < end; ++i) {
            float w = this.mMeasuredText.mAdvances[i];
            if (w == 0.0f) continue;
            if (width + w > this.mLineWidthLimit) {
                this.breakLineAt(i, width, this.mLineWidth - width, this.mCharsAdvance - width);
                return false;
            }
            width += w;
        }
        this.breakLineAt(end, this.mLineWidth, 0.0f, 0.0f);
        return true;
    }

    private void breakLineAt(int offset, float lineWidth, float remainingNextLineWidth, float remainingNextCharsAdvance) {
        this.mBreakPoints.add(new BreakPoint(offset, lineWidth));
        this.mLineWidthLimit = this.mLineWidthLimits.getAt(++this.mLineNum);
        this.mLineWidth = remainingNextLineWidth;
        this.mCharsAdvance = remainingNextCharsAdvance;
        this.mPrevBoundaryOffset = -1;
        this.mLineWidthAtPrevBoundary = 0.0f;
        this.mCharsAdvanceAtPrevBoundary = 0.0f;
    }

    private void updateLineWidth(char c, float adv) {
        if (c == '\t') {
            this.mLineWidth = this.mCharsAdvance = this.mTabStops.nextTab(this.mCharsAdvance);
        } else {
            this.mCharsAdvance += adv;
            if (!LineBreaker.isLineEndSpace(c)) {
                this.mLineWidth = this.mCharsAdvance;
            }
        }
    }

    private int getPrevLineBreakOffset() {
        return this.mBreakPoints.isEmpty() ? 0 : this.mBreakPoints.get(this.mBreakPoints.size() - 1).mOffset;
    }

    @Nonnull
    private Result getResult() {
        int prevBreakOffset = 0;
        int[] ascents = new int[this.mBreakPoints.size()];
        int[] descents = new int[this.mBreakPoints.size()];
        FontMetricsInt fm = new FontMetricsInt();
        for (int i = 0; i < this.mBreakPoints.size(); ++i) {
            BreakPoint breakPoint = this.mBreakPoints.get(i);
            for (int j = prevBreakOffset; j < breakPoint.mOffset; ++j) {
                if (this.mTextBuf[j] != '\t') continue;
                breakPoint.mHasTabChar = true;
                break;
            }
            fm.reset();
            this.mMeasuredText.getExtent(prevBreakOffset, breakPoint.mOffset, fm);
            ascents[i] = fm.mAscent;
            descents[i] = fm.mDescent;
            prevBreakOffset = breakPoint.mOffset;
        }
        return new Result(this.mBreakPoints.toArray(new BreakPoint[0]), ascents, descents);
    }

    public static class Result {
        private static final BreakPoint[] EMPTY_ARRAY = new BreakPoint[0];
        @Nonnull
        private final BreakPoint[] mBreakPoints;
        private final int[] mAscents;
        private final int[] mDescents;

        private Result() {
            this.mBreakPoints = EMPTY_ARRAY;
            this.mAscents = IntArrays.EMPTY_ARRAY;
            this.mDescents = IntArrays.EMPTY_ARRAY;
        }

        private Result(@Nonnull BreakPoint[] breakPoints, int[] ascents, int[] descents) {
            this.mBreakPoints = breakPoints;
            this.mAscents = ascents;
            this.mDescents = descents;
        }

        public int getLineCount() {
            return this.mBreakPoints.length;
        }

        public int getLineBreakOffset(int lineIndex) {
            return this.mBreakPoints[lineIndex].mOffset;
        }

        public float getLineWidth(int lineIndex) {
            return this.mBreakPoints[lineIndex].mLineWidth;
        }

        public float getLineAscent(int lineIndex) {
            return this.mAscents[lineIndex];
        }

        public float getLineDescent(int lineIndex) {
            return this.mDescents[lineIndex];
        }

        public boolean hasLineTab(int lineIndex) {
            return this.mBreakPoints[lineIndex].mHasTabChar;
        }
    }

    private static class TabStops {
        @Nullable
        private final float[] mStops;
        private final float mTabWidth;

        public TabStops(@Nullable float[] stops, float tabWidth) {
            this.mStops = stops;
            this.mTabWidth = tabWidth;
        }

        public float nextTab(float currWidth) {
            if (this.mStops != null) {
                for (float stop : this.mStops) {
                    if (!(stop > currWidth)) continue;
                    return stop;
                }
            }
            return (float)((int)(currWidth / this.mTabWidth + 1.0f)) * this.mTabWidth;
        }
    }

    private static class DefaultLineWidth
    implements LineWidth {
        private final float mFirstWidth;
        private final float mRestWidth;
        @Nullable
        private final float[] mIndents;
        private final int mOffset;

        public DefaultLineWidth(float firstWidth, float restWidth, @Nullable float[] indents, int offset) {
            this.mFirstWidth = firstWidth;
            this.mRestWidth = restWidth;
            this.mIndents = indents;
            this.mOffset = offset;
        }

        @Override
        public float getAt(int line) {
            float width = line < 1 ? this.mFirstWidth : this.mRestWidth;
            return Math.max(0.0f, width - this.getIndent(this.mIndents, line));
        }

        @Override
        public float getMin() {
            float minWidth = Math.min(this.getAt(0), this.getAt(1));
            if (this.mIndents != null) {
                int end = this.mIndents.length - this.mOffset;
                for (int line = 1; line < end; ++line) {
                    minWidth = Math.min(minWidth, this.getAt(line));
                }
            }
            return minWidth;
        }

        private float getIndent(@Nullable float[] indents, int line) {
            if (indents == null || indents.length == 0) {
                return 0.0f;
            }
            int index = line + this.mOffset;
            if (index < indents.length) {
                return indents[index];
            }
            return indents[indents.length - 1];
        }
    }

    public static interface LineWidth {
        default public float getAt(int line) {
            return 0.0f;
        }

        default public float getMin() {
            return 0.0f;
        }
    }

    public static class ParagraphConstraints {
        private float mWidth = 0.0f;
        private float mFirstWidth = 0.0f;
        @Nullable
        private float[] mVariableTabStops = null;
        private float mDefaultTabStop = 0.0f;

        public void setWidth(float width) {
            this.mWidth = width;
        }

        public void setIndent(float firstWidth) {
            this.mFirstWidth = firstWidth;
        }

        public void setTabStops(@Nullable float[] tabStops, float defaultTabStop) {
            this.mVariableTabStops = tabStops;
            this.mDefaultTabStop = defaultTabStop;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getFirstWidth() {
            return this.mFirstWidth;
        }

        @Nullable
        public float[] getTabStops() {
            return this.mVariableTabStops;
        }

        public float getDefaultTabStop() {
            return this.mDefaultTabStop;
        }
    }

    private static final class BreakPoint {
        private final int mOffset;
        private final float mLineWidth;
        private boolean mHasTabChar = false;

        public BreakPoint(int offset, float lineWidth) {
            this.mOffset = offset;
            this.mLineWidth = lineWidth;
        }
    }
}

